#!/bin/sh
info3=/rw/firmware/info3.gg
echo Resetting configuration settings to manufacturer defaults...
if [ "$(ls /rw/config/point_to_point_mode >& /dev/null ; echo $?)" == "0" ]; then RESETTX=1 ; fi
touch /rw/resetting
/usr/sbin/MtxBoardFactoryReset-NoDrv
/usr/sbin/MtxResetCtrl-NoDrv -fr
PCB=$(cat /etc/device/info1.gg | grep PcbNumber | cut -f2 -d'=' | cut -f1 -d'-')

if [ "${PCB}" == "7514" ]; then

    /usr/sbin/MtxResetOnLan-NoDrv -sr 492550
    /usr/sbin/MtxResetCtrl-NoDrv -wold

fi

mount -o remount,rw /rw

cp -f /rw/config/BootMark.txt /rw/firmware/

for ifile in $(find /rw/ -mindepth 1 -name firmware -prune -o -type d -print)
do
   rm -rf "$ifile"
done

rm /rw/*

mkdir -p /rw/config/
cp -f /rw/firmware/BootMark.txt /rw/config/
rm -f /rw/firmware/BootMark.txt

rm -f /rw/firmware/go
rm -f /rw/firmware/c?
rm -f /rw/firmware/c??
rm -f /rw/firmware/locks.log
rm -f /rw/firmware/current/*
rm -f /rw/firmware/validating/*

tar -zxf /rw.tar.gz -C /rw/
mkdir -p /rw/usr/local/SV2

if [ -f "/exe.config.tar.gz" ]; then

  tar -zxf /exe.config.tar.gz -C /rw/

fi

source /etc/device/info1.gg
echo $SerialNumber > /rw/shared/etc/hostname

if [ "$RECOVERCONNMAN" == "1" ]; then
    tar -zxf /connman.tar.gz -C /rw/shared/var/lib/connman/
fi

if [ -f "/etc/device/info2.gg" ]; then

  CUSTOM_NTP_SERVER=$(cat /etc/device/info2.gg | grep "NTPSERVER" | cut -f2 -d'=')
  
  if [ "${CUSTOM_NTP_SERVER}" != "" ]; then
  
      echo "[Time]" > /rw/shared/etc/systemd/timesyncd.conf
      echo "NTP=${CUSTOM_NTP_SERVER}" >> /rw/shared/etc/systemd/timesyncd.conf
      echo "FallbackNTP=time.matrox.com" >> /rw/shared/etc/systemd/timesyncd.conf
  
  fi

fi

if [ -f $info3 ]; then
        # invalidating entries in info3.gg
        echo "invalidating"
        sed -i "s/^\(EAP_TLS_CERTIFICATE=\).*$/\1unknown/" $info3
        sed -i "s/^\(SYSLOG_CERT=\).*$/\1unknown/" $info3
fi

if [ -f "/etc/rx.simplesettings" ]; then

    cp /etc/rx.simplesettings /rw/config/rx.simplesettings

fi

if [ -f /sbin/resetex.sh ]; then
  /sbin/resetex.sh
fi

if [ "${RESETTX}" == "1" ]; then touch /rw/boot/resettx ; fi
touch /rw/boot/reseteth

sync


